version	equ	0

;  Russell Nelson, Clarkson University.  December 24, 1989
;  Copyright, 1989, Russell Nelson

;   This program is free software; you can redistribute it and/or modify
;   it under the terms of the GNU General Public License as published by
;   the Free Software Foundation, version 1.
;
;   This program is distributed in the hope that it will be useful,
;   but WITHOUT ANY WARRANTY; without even the implied warranty of
;   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;   GNU General Public License for more details.
;
;   You should have received a copy of the GNU General Public License
;   along with this program; if not, write to the Free Software
;   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

	include	defs.asm

code	segment byte public
	assume	cs:code, ds:code

	org	80h
phd_dioa	label	byte

	org	100h
start:
	jmp	start_1
copyleft_msg	label	byte
 db "Packet sender version ",'0'+majver,".",'0'+version," copyright 1990, Russell Nelson.",CR,LF
 db "This program is free software; see the file COPYING for details.",CR,LF
 db "NO WARRANTY; see the file COPYING for details.",CR,LF
crlf_msg	db	CR,LF,'$'

int_pkt	macro
	pushf
	cli
	call	their_isr
	endm

their_isr	dd	?
packet_int_no	db	?,?
handle		dw	?
repeat_switch	db	?

send_count	dw	?

signature	db	'PKT DRVR',0
signature_len	equ	$-signature

no_signature_msg	db	"No packet driver at that address",'$'
usage_msg	db	"usage: pktsend <packet_int_no> [-r] [-f filename | packet]",'$'
sending_msg	label	byte
	db	"Press space to re-send packet.  Any other key exits.",CR,LF,'$'
repeat_msg	label	byte
	db	"Sending repeat packets.  Any key exits.",CR,LF,'$'
file_not_found	db	"File not found",'$'
read_trouble	db	"Trouble reading the file",'$'
non_number_msg	db	"Non-numeric input found",'$'
mem_trashed_msg	db	"Found trashed memory",'$'

line_buffer	db	128 dup(?)

usage_error:
	mov	dx,offset usage_msg
error:
	mov	ah,9
	int	21h
	int	20h

start_1:
	mov	dx,offset copyleft_msg
	mov	ah,9
	int	21h

	mov	si,offset phd_dioa+1
	cmp	byte ptr [si],CR	;end of line?
	je	usage_error

	mov	di,offset packet_int_no
	call	get_number

another_switch:
	call	skip_blanks

	mov	al,[si]			;did the give the packet inline?
	cmp	al,'-'			;did they specify a switch?
	jne	not_switch
	cmp	byte ptr [si+1],'r'	;did they specify '-r'?
	je	got_repeat_switch
	cmp	byte ptr [si+1],'f'	;did they specify '-f'?
	jne	usage_error		;no, must be an error.
	add	si,2
	call	skip_blanks
	jmp	start_file
got_repeat_switch:
	mov	repeat_switch,1
	add	si,2
	jmp	another_switch
not_switch:
	jmp	start_inline		;yes.

start_file:
	mov	dx,si			;remember where the filename starts.
start_3:
	lodsb
	cmp	al,' '
	je	start_4
	cmp	al,CR
	jne	start_3
start_4:
	dec	si
	mov	byte ptr [si],0

;read the packet bytes from the named file.

	mov	ax,3d00h		;open for reading.
	int	21h
	mov	dx,offset file_not_found
	jc	error
	mov	handle,ax

	mov	di,offset our_buffer
start_line:
	mov	si,offset line_buffer
again_line:
	mov	ah,3fh			;read a single character.
	mov	bx,handle
	mov	cx,1
	mov	dx,si
	int	21h
	mov	dx,offset read_trouble
	jc	error
	cmp	ax,1			;did we actually read one?
	je	not_eof
	cmp	si,offset line_buffer	;did we read anything this time?
	je	start_file_eof		;no, it's really eof this time.
	mov	[si],byte ptr CR	;add an extra CR, just in case.
	jmp	short done_reading
not_eof:
	lodsb				;get the character we just read.
	cmp	al,LF			;got the LF?
	jne	again_line		;no, read again.

done_reading:
	mov	si,offset line_buffer
again_chars:
	call	get_number
	jnc	got_a_number
	mov	dx,offset non_number_msg
	jmp	error
got_a_number:
	inc	di
	call	skip_blanks
	cmp	al,CR
	jne	again_chars		;keep going to the end.

	jmp	start_line

start_file_eof:
	mov	ah,3eh			;close the file.
	mov	bx,handle
	int	21h
	jmp	short start_gotit

start_inline:
;read the packet bytes off the command line.
	mov	di,offset our_buffer-1
start_2:
	inc	di			;pre-increment
	call	get_number		;get a byte.
	jnc	start_2			;keep going to the end.

start_gotit:

	sub	di,offset our_buffer
	mov	send_count,di

	mov	sp,offset start		;now that we're finished with
					;the parameters, put our stack there.

	mov	di,offset our_buffer + GIANT * 2
	inc	di
	and	di,not 1
	push	cs
	pop	es
init_memory:
	mov	ax,055aah		;initialize a segment to 055aah.
	mov	cx,di
	neg	cx
	shr	cx,1
	stosw
	sub	cx,2
	rep	stosw
	mov	ax,es
	add	ax,1000h
	mov	es,ax
	cmp	ax,9000h		;don't go past 9000h.
	jbe	init_memory

	mov	ah,35h			;get their packet interrupt.
	mov	al,packet_int_no
	int	21h
	mov	their_isr.offs,bx
	mov	their_isr.segm,es

	lea	di,3[bx]
	mov	si,offset signature
	mov	cx,signature_len
	repe	cmpsb
	je	signature_ok
	jmp	no_signature_err
signature_ok:

	push	ds
	mov	ax,1ffh			;driver_info
	int_pkt
	pop	ds
	call	fatal_error

	mov	ah,2			;access all packets.
	mov	al,ch			;their class from driver_info().
	mov	bx,dx			;their type from driver_info().
	mov	dl,cl			;their number from driver_info().
	mov	cx,0			;type length of zero.
	push	cs			;es:di -> our receiver.
	pop	es
	mov	di,offset our_recv
	int_pkt
	call	fatal_error
	mov	handle,ax

	mov	dx,offset sending_msg
	cmp	repeat_switch,0
	je	say_sending
	mov	dx,offset repeat_msg
say_sending:
	mov	ah,9
	int	21h

wait_for_key:
	mov	ah,4
	mov	si,offset our_buffer	;ds:si -> buffer.
	mov	cx,send_count
	int_pkt
	jc	pkt_bad

	cmp	repeat_switch,0		;did they ask for repeat sending?
	jne	send_repeat

	mov	ah,0			;read a key.
	int	16h
	cmp	al,' '
	je	wait_for_key		;a space -- send again.
	jmp	short send_done

send_repeat:
	mov	al,'.'
	call	chrout

	mov	ah,1			;check for any key.
	int	16h
	je	wait_for_key		;no key -- keep waiting.
send_done:

	mov	ah,0			;read a key.
	int	16h

	mov	ah,3			;release the handle.
	mov	bx,handle
	int_pkt
	call	fatal_error

	mov	di,offset our_buffer + GIANT * 2
	inc	di
	and	di,not 1
	push	cs
	pop	es
compare_memory:
	mov	ax,055aah		;compare a segment against 055aah.
	mov	cx,di
	neg	cx
	shr	cx,1
	scasw
	jne	memory_bad
	sub	cx,2
	repe	scasw
	jne	memory_bad
	mov	ax,es
	add	ax,1000h
	mov	es,ax
	cmp	ax,9000h		;don't go past 9000h.
	jbe	compare_memory

	int	20h
pkt_bad:
	call	print_error
	int	20h

memory_bad:
	mov	dx,offset mem_trashed_msg
	mov	ah,9
	int	21h
	int	20h

no_signature_err:
	mov	dx,offset no_signature_msg
	mov	ah,9
	int	21h
	int	20h


our_recv:
	or	ax,ax			;first or second call?
	jne	our_recv_1		;second -- we ignore the packet
	push	cs
	pop	es
	mov	di,offset our_buffer + GIANT
our_recv_1:
	db	0cbh			;masm 4.0 doesn't grok "retf"


	include	pkterr.asm
	include	getnum.asm
	include	getdig.asm
	include	skipblk.asm
	include	chrout.asm

our_buffer	label	byte

code	ends

	end	start
